<?php
/***************************************************************************
*                                                                          *
*   (c) 2004 Vladimir V. Kalynyak, Alexey V. Vinokurov, Ilya M. Shalnev    *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

use Tygh\Enum\Addons\MobileApp\ColorPresets;

defined('BOOTSTRAP') or die('Access denied');

return [
    ColorPresets::BYDEFAULT => [
        'name'   => 'mobile_app.color_preset_bright',
        'colors' => [
            'categories'     =>
                [
                    'categoriesBackgroundColor'    =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'categoriesHeaderColor'        =>
                        [
                            'value' => '#000',
                        ],
                    'categoryBlockBackgroundColor' =>
                        [
                            'value' => '#FFF',
                        ],
                    'categoryBlockTextColor'       =>
                        [
                            'value' => '#000',
                        ],
                    'categoryBorderRadius'         =>
                        [
                            'value' => '6',
                        ],
                ],
            'bottom_tabs'    =>
                [
                    'bottomTabsBackgroundColor'   =>
                        [
                            'value' => '#fff',
                        ],
                    'bottomTabsTextColor'         =>
                        [
                            'value' => '#888888',
                        ],
                    'bottomTabsSelectedTextColor' =>
                        [
                            'value' => '#000',
                        ],
                    'bottomTabsIconColor'         =>
                        [
                            'value' => '#888888',
                        ],
                    'bottomTabsSelectedIconColor' =>
                        [
                            'value' => '#000',
                        ],
                    'bottomTabsPrimaryBadgeColor' =>
                        [
                            'value' => '#FD542A',
                        ],
                ],
            'navbar'         =>
                [
                    'statusBarColor'        =>
                        [
                            'value' => '#c1c1c1',
                        ],
                    'navBarBackgroundColor' =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'navBarButtonColor'     =>
                        [
                            'value' => '#989898',
                        ],
                    'navBarTextColor'       =>
                        [
                            'value' => '#242424',
                        ],
                    'screenBackgroundColor' =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTitleFontSize'   =>
                        [
                            'value' => '16',
                        ],
                ],
            'product_screen' =>
                [
                    'buttonBackgroundColor'            =>
                        [
                            'value' => '#FF6008',
                        ],
                    'buttonWithBackgroundTextColor'    =>
                        [
                            'value' => '#fff',
                        ],
                    'buttonWithoutBackgroundTextColor' =>
                        [
                            'value' => '#FF6008',
                        ],
                    'ratingStarsColor'                 =>
                        [
                            'value' => '#EAA944',
                        ],
                    'discussionMessageColor'           =>
                        [
                            'value' => '#808080',
                        ],
                    'darkColor'                        =>
                        [
                            'value' => '#242424',
                        ],
                    'grayColor'                        =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'mediumGrayColor'                  =>
                        [
                            'value' => '#B8B8B8',
                        ],
                    'categoryEmptyImage'               =>
                        [
                            'value' => '#989898',
                        ],
                ],
            'other'          =>
                [
                    'successColor'           =>
                        [
                            'value' => '#7DCFB6',
                        ],
                    'infoColor'              =>
                        [
                            'value' => '#FCEADE',
                        ],
                    'dangerColor'            =>
                        [
                            'value' => '#D9534F',
                        ],
                    'borderRadius'           =>
                        [
                            'value' => '8',
                        ],
                    'productDiscountColor'   =>
                        [
                            'value' => '#EAA944',
                        ],
                    'productBorderColor'     =>
                        [
                            'value' => '#FFF',
                        ],
                    'pushNotificationsColor' =>
                        [
                            'value' => '#26323e',
                        ],
                    'dotsSwiperColor'        =>
                        [
                            'value' => '#0085FE',
                        ],
                ],
            'profile'        =>
                [
                    'menuItemsBorderColor' =>
                        [
                            'value' => '#f3f3f3',
                        ],
                    'menuIconsColor'       =>
                        [
                            'value' => '#d3d3d3',
                        ],
                    'menuTextColor'        =>
                        [
                            'value' => '#424040',
                        ],
                ],
        ],
    ],
    ColorPresets::ORANGE    => [
        'name'   => 'mobile_app.color_preset_orange',
        'colors' => [
            'categories'     =>
                [
                    'categoriesBackgroundColor'    =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'categoriesHeaderColor'        =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBlockBackgroundColor' =>
                        [
                            'value' => '#FFF',
                        ],
                    'categoryBlockTextColor'       =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBorderRadius'         =>
                        [
                            'value' => '6',
                        ],
                ],
            'bottom_tabs'    =>
                [
                    'bottomTabsBackgroundColor'   =>
                        [
                            'value' => '#fff',
                        ],
                    'bottomTabsTextColor'         =>
                        [
                            'value' => '#6A6A6A',
                        ],
                    'bottomTabsSelectedTextColor' =>
                        [
                            'value' => '#F8642D',
                        ],
                    'bottomTabsIconColor'         =>
                        [
                            'value' => '#6A6A6A',
                        ],
                    'bottomTabsSelectedIconColor' =>
                        [
                            'value' => '#F8642D',
                        ],
                    'bottomTabsPrimaryBadgeColor' =>
                        [
                            'value' => '#F8642D',
                        ],
                ],
            'navbar'         =>
                [
                    'statusBarColor'        =>
                        [
                            'value' => '#c1c1c1',
                        ],
                    'navBarBackgroundColor' =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarButtonColor'     =>
                        [
                            'value' => '#010005',
                        ],
                    'navBarTextColor'       =>
                        [
                            'value' => '#242424',
                        ],
                    'screenBackgroundColor' =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTitleFontSize'   =>
                        [
                            'value' => '16',
                        ],
                ],
            'product_screen' =>
                [
                    'buttonBackgroundColor'            =>
                        [
                            'value' => '#FF4843',
                        ],
                    'buttonWithBackgroundTextColor'    =>
                        [
                            'value' => '#fff',
                        ],
                    'buttonWithoutBackgroundTextColor' =>
                        [
                            'value' => '#FF4843',
                        ],
                    'ratingStarsColor'                 =>
                        [
                            'value' => '#EAA944',
                        ],
                    'discussionMessageColor'           =>
                        [
                            'value' => '#808080',
                        ],
                    'darkColor'                        =>
                        [
                            'value' => '#242424',
                        ],
                    'grayColor'                        =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'mediumGrayColor'                  =>
                        [
                            'value' => '#B8B8B8',
                        ],
                    'categoryEmptyImage'               =>
                        [
                            'value' => '#989898',
                        ],
                ],
            'other'          =>
                [
                    'successColor'           =>
                        [
                            'value' => '#7DCFB6',
                        ],
                    'infoColor'              =>
                        [
                            'value' => '#FCEADE',
                        ],
                    'dangerColor'            =>
                        [
                            'value' => '#D9534F',
                        ],
                    'borderRadius'           =>
                        [
                            'value' => '8',
                        ],
                    'productDiscountColor'   =>
                        [
                            'value' => '#FA9300',
                        ],
                    'productBorderColor'     =>
                        [
                            'value' => '#FFF',
                        ],
                    'pushNotificationsColor' =>
                        [
                            'value' => '#26323e',
                        ],
                    'dotsSwiperColor'        =>
                        [
                            'value' => '#FF4843',
                        ],
                ],
            'profile'        =>
                [
                    'menuItemsBorderColor' =>
                        [
                            'value' => '#f3f3f3',
                        ],
                    'menuIconsColor'       =>
                        [
                            'value' => '#d3d3d3',
                        ],
                    'menuTextColor'        =>
                        [
                            'value' => '#424040',
                        ],
                ],
        ],
    ],
    ColorPresets::MARINE    => [
        'name'   => 'mobile_app.color_preset_marine',
        'colors' => [
            'categories'     =>
                [
                    'categoriesBackgroundColor'    =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'categoriesHeaderColor'        =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBlockBackgroundColor' =>
                        [
                            'value' => '#FFF',
                        ],
                    'categoryBlockTextColor'       =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBorderRadius'         =>
                        [
                            'value' => '6',
                        ],
                ],
            'bottom_tabs'    =>
                [
                    'bottomTabsBackgroundColor'   =>
                        [
                            'value' => '#fff',
                        ],
                    'bottomTabsTextColor'         =>
                        [
                            'value' => '#4b5151',
                        ],
                    'bottomTabsSelectedTextColor' =>
                        [
                            'value' => '#2f848d',
                        ],
                    'bottomTabsIconColor'         =>
                        [
                            'value' => '#4b5151',
                        ],
                    'bottomTabsSelectedIconColor' =>
                        [
                            'value' => '#2f848d',
                        ],
                    'bottomTabsPrimaryBadgeColor' =>
                        [
                            'value' => '#026C79',
                        ],
                ],
            'navbar'         =>
                [
                    'statusBarColor'        =>
                        [
                            'value' => '#c1c1c1',
                        ],
                    'navBarBackgroundColor' =>
                        [
                            'value' => '#8dd9d4',
                        ],
                    'navBarButtonColor'     =>
                        [
                            'value' => '#010005',
                        ],
                    'navBarTextColor'       =>
                        [
                            'value' => '#242424',
                        ],
                    'screenBackgroundColor' =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTitleFontSize'   =>
                        [
                            'value' => '16',
                        ],
                ],
            'product_screen' =>
                [
                    'buttonBackgroundColor'            =>
                        [
                            'value' => '#ffd816',
                        ],
                    'buttonWithBackgroundTextColor'    =>
                        [
                            'value' => '#120c00',
                        ],
                    'buttonWithoutBackgroundTextColor' =>
                        [
                            'value' => '#026C79',
                        ],
                    'ratingStarsColor'                 =>
                        [
                            'value' => '#EAA944',
                        ],
                    'discussionMessageColor'           =>
                        [
                            'value' => '#808080',
                        ],
                    'darkColor'                        =>
                        [
                            'value' => '#242424',
                        ],
                    'grayColor'                        =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'mediumGrayColor'                  =>
                        [
                            'value' => '#B8B8B8',
                        ],
                    'categoryEmptyImage'               =>
                        [
                            'value' => '#989898',
                        ],
                ],
            'other'          =>
                [
                    'successColor'           =>
                        [
                            'value' => '#7DCFB6',
                        ],
                    'infoColor'              =>
                        [
                            'value' => '#FCEADE',
                        ],
                    'dangerColor'            =>
                        [
                            'value' => '#D9534F',
                        ],
                    'borderRadius'           =>
                        [
                            'value' => '8',
                        ],
                    'productDiscountColor'   =>
                        [
                            'value' => '#EB7700',
                        ],
                    'productBorderColor'     =>
                        [
                            'value' => '#FFF',
                        ],
                    'pushNotificationsColor' =>
                        [
                            'value' => '#26323e',
                        ],
                    'dotsSwiperColor'        =>
                        [
                            'value' => '#026C79',
                        ],
                ],
            'profile'        =>
                [
                    'menuItemsBorderColor' =>
                        [
                            'value' => '#f3f3f3',
                        ],
                    'menuIconsColor'       =>
                        [
                            'value' => '#D3D3D3',
                        ],
                    'menuTextColor'        =>
                        [
                            'value' => '#424040',
                        ],
                ],
        ],
    ],
    ColorPresets::NAVYBLUE  => [
        'name'   => 'mobile_app.color_preset_navyblue',
        'colors' => [
            'categories'     =>
                [
                    'categoriesBackgroundColor'    =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'categoriesHeaderColor'        =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBlockBackgroundColor' =>
                        [
                            'value' => '#FFF',
                        ],
                    'categoryBlockTextColor'       =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBorderRadius'         =>
                        [
                            'value' => '6',
                        ],
                ],
            'bottom_tabs'    =>
                [
                    'bottomTabsBackgroundColor'   =>
                        [
                            'value' => '#fff',
                        ],
                    'bottomTabsTextColor'         =>
                        [
                            'value' => '#6A6A6A',
                        ],
                    'bottomTabsSelectedTextColor' =>
                        [
                            'value' => '#3665F1',
                        ],
                    'bottomTabsIconColor'         =>
                        [
                            'value' => '#6A6A6A',
                        ],
                    'bottomTabsSelectedIconColor' =>
                        [
                            'value' => '#3665F1',
                        ],
                    'bottomTabsPrimaryBadgeColor' =>
                        [
                            'value' => '#3665F1',
                        ],
                ],
            'navbar'         =>
                [
                    'statusBarColor'        =>
                        [
                            'value' => '#c1c1c1',
                        ],
                    'navBarBackgroundColor' =>
                        [
                            'value' => '#171A1F',
                        ],
                    'navBarButtonColor'     =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTextColor'       =>
                        [
                            'value' => '#fff',
                        ],
                    'screenBackgroundColor' =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTitleFontSize'   =>
                        [
                            'value' => '16',
                        ],
                ],
            'product_screen' =>
                [
                    'buttonBackgroundColor'            =>
                        [
                            'value' => '#3665F1',
                        ],
                    'buttonWithBackgroundTextColor'    =>
                        [
                            'value' => '#fff',
                        ],
                    'buttonWithoutBackgroundTextColor' =>
                        [
                            'value' => '#3665F1',
                        ],
                    'ratingStarsColor'                 =>
                        [
                            'value' => '#EAA944',
                        ],
                    'discussionMessageColor'           =>
                        [
                            'value' => '#808080',
                        ],
                    'darkColor'                        =>
                        [
                            'value' => '#242424',
                        ],
                    'grayColor'                        =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'mediumGrayColor'                  =>
                        [
                            'value' => '#B8B8B8',
                        ],
                    'categoryEmptyImage'               =>
                        [
                            'value' => '#989898',
                        ],
                ],
            'other'          =>
                [
                    'successColor'           =>
                        [
                            'value' => '#7DCFB6',
                        ],
                    'infoColor'              =>
                        [
                            'value' => '#FCEADE',
                        ],
                    'dangerColor'            =>
                        [
                            'value' => '#D9534F',
                        ],
                    'borderRadius'           =>
                        [
                            'value' => '8',
                        ],
                    'productDiscountColor'   =>
                        [
                            'value' => '#ED1754',
                        ],
                    'productBorderColor'     =>
                        [
                            'value' => '#FFF',
                        ],
                    'pushNotificationsColor' =>
                        [
                            'value' => '#26323e',
                        ],
                    'dotsSwiperColor'        =>
                        [
                            'value' => '#3665F1',
                        ],
                ],
            'profile'        =>
                [
                    'menuItemsBorderColor' =>
                        [
                            'value' => '#f3f3f3',
                        ],
                    'menuIconsColor'       =>
                        [
                            'value' => '#d3d3d3',
                        ],
                    'menuTextColor'        =>
                        [
                            'value' => '#424040',
                        ],
                ],
        ],
    ],
    ColorPresets::BERRY     => [
        'name'   => 'mobile_app.color_preset_berry',
        'colors' => [
            'categories'     =>
                [
                    'categoriesBackgroundColor'    =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'categoriesHeaderColor'        =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBlockBackgroundColor' =>
                        [
                            'value' => '#FFF',
                        ],
                    'categoryBlockTextColor'       =>
                        [
                            'value' => '#303433',
                        ],
                    'categoryBorderRadius'         =>
                        [
                            'value' => '6',
                        ],
                ],
            'bottom_tabs'    =>
                [
                    'bottomTabsBackgroundColor'   =>
                        [
                            'value' => '#fff',
                        ],
                    'bottomTabsTextColor'         =>
                        [
                            'value' => '#6A6A6A',
                        ],
                    'bottomTabsSelectedTextColor' =>
                        [
                            'value' => '#B153DD',
                        ],
                    'bottomTabsIconColor'         =>
                        [
                            'value' => '#6A6A6A',
                        ],
                    'bottomTabsSelectedIconColor' =>
                        [
                            'value' => '#B153DD',
                        ],
                    'bottomTabsPrimaryBadgeColor' =>
                        [
                            'value' => '#B153DD',
                        ],
                ],
            'navbar'         =>
                [
                    'statusBarColor'        =>
                        [
                            'value' => '#c1c1c1',
                        ],
                    'navBarBackgroundColor' =>
                        [
                            'value' => '#6623A4',
                        ],
                    'navBarButtonColor'     =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTextColor'       =>
                        [
                            'value' => '#fff',
                        ],
                    'screenBackgroundColor' =>
                        [
                            'value' => '#fff',
                        ],
                    'navBarTitleFontSize'   =>
                        [
                            'value' => '16',
                        ],
                ],
            'product_screen' =>
                [
                    'buttonBackgroundColor'            =>
                        [
                            'value' => '#560B99',
                        ],
                    'buttonWithBackgroundTextColor'    =>
                        [
                            'value' => '#fff',
                        ],
                    'buttonWithoutBackgroundTextColor' =>
                        [
                            'value' => '#560B99',
                        ],
                    'ratingStarsColor'                 =>
                        [
                            'value' => '#EAA944',
                        ],
                    'discussionMessageColor'           =>
                        [
                            'value' => '#808080',
                        ],
                    'darkColor'                        =>
                        [
                            'value' => '#242424',
                        ],
                    'grayColor'                        =>
                        [
                            'value' => '#FAFAFA',
                        ],
                    'mediumGrayColor'                  =>
                        [
                            'value' => '#B8B8B8',
                        ],
                    'categoryEmptyImage'               =>
                        [
                            'value' => '#989898',
                        ],
                ],
            'other'          =>
                [
                    'successColor'           =>
                        [
                            'value' => '#7DCFB6',
                        ],
                    'infoColor'              =>
                        [
                            'value' => '#FCEADE',
                        ],
                    'dangerColor'            =>
                        [
                            'value' => '#D9534F',
                        ],
                    'borderRadius'           =>
                        [
                            'value' => '8',
                        ],
                    'productDiscountColor'   =>
                        [
                            'value' => '#E400B4',
                        ],
                    'productBorderColor'     =>
                        [
                            'value' => '#FFF',
                        ],
                    'pushNotificationsColor' =>
                        [
                            'value' => '#26323e',
                        ],
                    'dotsSwiperColor'        =>
                        [
                            'value' => '#6623A4',
                        ],
                ],
            'profile'        =>
                [
                    'menuItemsBorderColor' =>
                        [
                            'value' => '#f3f3f3',
                        ],
                    'menuIconsColor'       =>
                        [
                            'value' => '#D3D3D3',
                        ],
                    'menuTextColor'        =>
                        [
                            'value' => '#424040',
                        ],
                ],
        ],
    ],
    ColorPresets::CUSTOM    => [
        'name' => 'mobile_app.color_preset_custom',
    ],
];
