<?php
require_once dirname(__FILE__) . '/../../TestUnitDB.php';

use Tygh\Tools\ImageHelper;

class ImageHelperTest extends TestUnitDB
{
    /**
     * @dataProvider dpOrigProportionsFallback
     */
    public function testOriginalProportionsFallback($orig_width, $orig_height, $new_width, $new_height, $expected_new_width, $expected_new_height)
    {
        list ($new_width, $new_height) = ImageHelper::originalProportionsFallback($orig_width, $orig_height, $new_width, $new_height);
        $this->assertEquals($expected_new_width, $new_width);
        $this->assertEquals($expected_new_height, $new_height);
    }

    public function dpOrigProportionsFallback()
    {
        return array(
            array(
                100,
                500,
                50,
                250,
                50,
                250
            ),
            array(
                1000,
                1000,
                500,
                0,
                500,
                500
            ),
            array(
                1000,
                1000,
                0,
                500,
                500,
                500
            ),
            array(
                1000,
                2000,
                100,
                0,
                100,
                200
            ),
            array(
                1000,
                2000,
                0,
                100,
                50,
                100,
            ),
        );
    }
}