<?php

namespace Tygh\Api\Entities;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

use Tygh\Api\Entities\Blocks;
use Tygh\Api\Response;

/**
 * Tests API Blocks entity
 */
class BlocksTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Blocks
     */
    protected $entity;

    protected function setUp()
    {
        parent::setUp();

        $this->entity = new Blocks(array(
            'area'                      => 'A',
            'user_id'                   => '1',
            'user_type'                 => 'A',
            'tax_exempt'                => 'N',
            'last_login'                => '1343637055',
            'usergroup_ids'             => array(),
            'order_ids'                 => array(),
            'act_as_user'               => false,
            'this_login'                => 1343652763,
            'password_change_timestamp' => 0,
            'company_id'                => 0,
            'is_root'                   => 'Y',
            'referer'                   => '',
            'ip'                        => '192.168.1.111',
            'first_expire_check'        => false
        ));

    }

    protected function tearDown()
    {
    }

    protected function dsProvider()
    {
        $data = array(
            'companies.xml',
            'company_descriptions.xml',
            'bm_blocks.xml',
            'bm_blocks_descriptions.xml',
            'bm_blocks_content.xml',
        );

        return $data;
    }

    /**
     *
     * @dataProvider providerIndex()
     * @datasetProvider dsProvider
     */
    public function testIndex($id, $params, $result)
    {
        $actual = $this->entity->index($id, $params);
        $this->assertEquals($result, $actual);
    }

    public function providerIndex()
    {
        return array(

            // Index
            array(
                '',
                array(),
                array(
                  'status' => 200,
                  'data' =>
                  array (
                    0 =>
                    array (
                      'block_id' => '19',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/404.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => '404',
                    ),
                    1 =>
                    array (
                      'block_id' => '16',
                      'type' => 'smarty_block',
                      'properties' =>
                      array (
                        'template' => 'blocks/smarty_block.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'About us',
                    ),
                    2 =>
                    array (
                      'block_id' => '20',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/auth_info.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Auth information',
                    ),
                    3 =>
                    array (
                      'block_id' => '31',
                      'type' => 'smarty_block',
                      'properties' =>
                      array (
                        'template' => 'blocks/smarty_block.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Benefits & Guarantees',
                    ),
                    4 =>
                    array (
                      'block_id' => '32',
                      'type' => 'blog',
                      'properties' =>
                      array (
                        'template' => 'addons/blog/blocks/recent_posts_scroller.tpl',
                        'limit' => '10',
                        'not_scroll_automatically' => 'Y',
                        'speed' => '400',
                        'pause_delay' => '3',
                        'item_quantity' => '1',
                        'outside_navigation' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Blog',
                    ),
                    5 =>
                    array (
                      'block_id' => '1',
                      'type' => 'breadcrumbs',
                      'properties' =>
                      array (
                        'template' => 'common/breadcrumbs.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Breadcrumbs',
                    ),
                    6 =>
                    array (
                      'block_id' => '5',
                      'type' => 'cart_content',
                      'properties' =>
                      array (
                        'template' => 'blocks/cart_content.tpl',
                        'display_bottom_buttons' => 'Y',
                        'display_delete_icons' => 'Y',
                        'products_links_type' => 'thumb',
                        'generate_block_title' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Cart content',
                    ),
                    7 =>
                    array (
                      'block_id' => '17',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/copyright.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Copyright',
                    ),
                    8 =>
                    array (
                      'block_id' => '8',
                      'type' => 'currencies',
                      'properties' =>
                      array (
                        'template' => 'blocks/currencies.tpl',
                        'text' => '',
                        'format' => 'symbol',
                        'dropdown_limit' => '3',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Currencies',
                    ),
                    9 =>
                    array (
                      'block_id' => '15',
                      'type' => 'smarty_block',
                      'properties' =>
                      array (
                        'template' => 'blocks/smarty_block.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Customer Service',
                    ),
                    10 =>
                    array (
                      'block_id' => '14',
                      'type' => 'smarty_block',
                      'properties' =>
                      array (
                        'template' => 'blocks/smarty_block.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Demo Store',
                    ),
                    11 =>
                    array (
                      'block_id' => '29',
                      'type' => 'products',
                      'properties' =>
                      array (
                        'template' => 'blocks/products/products_scroller.tpl',
                        'show_price' => 'N',
                        'enable_quick_view' => 'N',
                        'not_scroll_automatically' => 'Y',
                        'speed' => '400',
                        'scroll_per_page' => 'Y',
                        'pause_delay' => '3',
                        'item_quantity' => '4',
                        'thumbnail_width' => '160',
                        'hide_add_to_cart_button' => 'Y',
                        'outside_navigation' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Hot deals',
                    ),
                    12 =>
                    array (
                      'block_id' => '7',
                      'type' => 'languages',
                      'properties' =>
                      array (
                        'template' => 'blocks/languages.tpl',
                        'text' => '',
                        'format' => 'name',
                        'dropdown_limit' => '0',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Languages',
                    ),
                    13 =>
                    array (
                      'block_id' => '3',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/logo.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Logo',
                    ),
                    14 =>
                    array (
                      'block_id' => '28',
                      'type' => 'banners',
                      'properties' =>
                      array (
                        'template' => 'addons/banners/blocks/carousel.tpl',
                        'navigation' => 'D',
                        'delay' => '7',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Main banners',
                    ),
                    15 =>
                    array (
                      'block_id' => '2',
                      'type' => 'main',
                      'properties' => '',
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Main Content',
                    ),
                    16 =>
                    array (
                      'block_id' => '9',
                      'type' => 'my_account',
                      'properties' =>
                      array (
                        'template' => 'blocks/my_account.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'My Account',
                    ),
                    17 =>
                    array (
                      'block_id' => '13',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/my_account_links.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'My account',
                    ),
                    18 =>
                    array (
                      'block_id' => '30',
                      'type' => 'products',
                      'properties' =>
                      array (
                        'template' => 'blocks/products/products_multicolumns.tpl',
                        'item_number' => 'N',
                        'number_of_columns' => '4',
                        'hide_add_to_cart_button' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'On Sale',
                    ),
                    19 =>
                    array (
                      'block_id' => '23',
                      'type' => 'checkout',
                      'properties' =>
                      array (
                        'template' => 'blocks/checkout/order_info.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Order information',
                    ),
                    20 =>
                    array (
                      'block_id' => '21',
                      'type' => 'checkout',
                      'properties' =>
                      array (
                        'template' => 'blocks/checkout/summary.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Order summary',
                    ),
                    21 =>
                    array (
                      'block_id' => '34',
                      'type' => 'our_brands',
                      'properties' =>
                      array (
                        'template' => 'blocks/our_brands.tpl',
                        'not_scroll_automatically' => 'Y',
                        'speed' => '400',
                        'scroll_per_page' => 'Y',
                        'pause_delay' => '3',
                        'item_quantity' => '7',
                        'thumbnail_width' => '75',
                        'outside_navigation' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Our brands',
                    ),
                    22 =>
                    array (
                      'block_id' => '18',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/payment_icons.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Payment icons',
                    ),
                    23 =>
                    array (
                      'block_id' => '25',
                      'type' => 'product_filters',
                      'properties' =>
                      array (
                        'template' => 'blocks/product_filters/original.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Product filters',
                    ),
                    24 =>
                    array (
                      'block_id' => '35',
                      'type' => 'product_filters',
                      'properties' =>
                      array (
                        'template' => 'blocks/product_filters/horizontal_filters.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Product filters',
                    ),
                    25 =>
                    array (
                      'block_id' => '22',
                      'type' => 'checkout',
                      'properties' =>
                      array (
                        'template' => 'blocks/checkout/products_in_cart.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Products in your order',
                    ),
                    26 =>
                    array (
                      'block_id' => '27',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/profile_info.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Profile information',
                    ),
                    27 =>
                    array (
                      'block_id' => '10',
                      'type' => 'menu',
                      'properties' =>
                      array (
                        'template' => 'blocks/menu/text_links.tpl',
                        'show_items_in_line' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Quick links',
                    ),
                    28 =>
                    array (
                      'block_id' => '26',
                      'type' => 'products',
                      'properties' =>
                      array (
                        'template' => 'blocks/products/products_small_items.tpl',
                        'item_number' => 'N',
                        'hide_add_to_cart_button' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Recently Viewed',
                    ),
                    29 =>
                    array (
                      'block_id' => '33',
                      'type' => 'testimonials',
                      'properties' =>
                      array (
                        'template' => 'addons/discussion/blocks/testimonials.tpl',
                        'limit' => '10',
                        'random' => 'N',
                        'not_scroll_automatically' => 'Y',
                        'speed' => '400',
                        'pause_delay' => '3',
                        'item_quantity' => '2',
                        'outside_navigation' => 'Y',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Reviews',
                    ),
                    30 =>
                    array (
                      'block_id' => '4',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/search.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Search',
                    ),
                    31 =>
                    array (
                      'block_id' => '24',
                      'type' => 'product_filters',
                      'properties' =>
                      array (
                        'template' => 'blocks/product_filters/selected_filters.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Selected product filters',
                    ),
                    32 =>
                    array (
                      'block_id' => '12',
                      'type' => 'smarty_block',
                      'properties' =>
                      array (
                        'template' => 'blocks/smarty_block.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Social links',
                    ),
                    33 =>
                    array (
                      'block_id' => '11',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'addons/newsletters/blocks/static_templates/subscribe.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Subscribe',
                    ),
                    34 =>
                    array (
                      'block_id' => '6',
                      'type' => 'categories',
                      'properties' =>
                      array (
                        'template' => 'blocks/categories/categories_dropdown_horizontal.tpl',
                        'dropdown_second_level_elements' => '12',
                        'dropdown_third_level_elements' => '6',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Top menu',
                    ),
                  ),
                ),
            ),

            // By Id
            array(
                17,
                array(),
                array(
                    'status' => 200,
                    'data' =>
                    array (
                      'block_id' => '17',
                      'type' => 'template',
                      'properties' =>
                      array (
                        'template' => 'blocks/static_templates/copyright.tpl',
                      ),
                      'company_id' => '1',
                      'lang_code' => 'en',
                      'name' => 'Copyright',
                      'content' => '',
                    ),
                ),
            ),
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     * @datasetProvider dsProvider
     */
    public function testCreate($params, $result)
    {
        $actual = $this->entity->create($params);
        $this->assertEquals($result, $actual);
    }

    public function providerCreate()
    {
        return array(
            // Try create with empty data
            array(
                array(),
                array(
                    'status' => Response::STATUS_BAD_REQUEST,
                    'data' => array(
                        'message' => 'The name field is required',
                    ),
                ),
            ),
            
            array(
                array(
                    'company_id' => 1,
                    'type' => 'template',
                    'name' => 'Example template',
                    'properties' => array(
                        'template' => 'blocks/static_templates/my_account_links.tpl'
                    ),
                ),
                array(
                    'status' => Response::STATUS_CREATED,
                    'data' => array(
                        'block_id' => 36,
                    ),
                ),
            ),
            array(
                array(
                    'company_id' => 1,
                    'type' => 'html_block',
                    'name' => 'Html block example',
                    'properties' => array(
                        'template' => 'blocks/html_block.tpl'
                    ),
                    'content' => array(
                        'content' => '<p>Example text</p>'
                    ),
                    'lang_code' => 'en'
                ),
                array(
                    'status' => Response::STATUS_CREATED,
                    'data' => array(
                        'block_id' => 36,
                    ),
                ),
            ),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     * @datasetProvider dsProvider
     */
    public function testUpdate($id, $params, $result)
    {
        $actual = $this->entity->update($id, $params);

        if ($actual['status'] == Response::STATUS_OK) {
            $res = $this->entity->index($id);
            $this->assertEquals($params['properties'], $res['data']['properties']);
        }

        $this->assertEquals($result, $actual);
    }

    public function providerUpdate()
    {
        return array(
            // Try update. Bad id.
            array(
                133,
                array(
                    'properties' => array(
                        'template' => 'blocks/static_templates/my_account_links.tpl'
                    ),
                ),
                array(
                    'status' => Response::STATUS_BAD_REQUEST,
                    'data' => array(
                        'message' => 'The type field is required',
                    ),
                )
            ),

            // Try update
            array(
                3,
                array(
                    'type' => 'template',
                    'properties' => array(
                        'template' => 'blocks/static_templates/my_account_links.tpl'
                    ),
                ),
                array(
                    'status' => Response::STATUS_OK,
                    'data' => array(
                        'block_id' => 3
                    ),
                )
            ),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     * @datasetProvider dsProvider
     */
    public function testDelete($id, $result)
    {
        $actual = $this->entity->delete($id);
        $this->assertEquals($result, $actual);
    }

    public function providerDelete()
    {
        return array(
            // Try delete with empty id
            array(
                '',
                array(
                    'status' => Response::STATUS_NOT_FOUND,
                    'data' => array(),
                ),
            ),
            // Try delete with nonexistent id
            array(
                133,
                array(
                    'status' => Response::STATUS_NOT_FOUND,
                    'data' => array(),
                ),
            ),
            // Try delete
            array(
                35,
                array(
                    'status' => Response::STATUS_NO_CONTENT,
                    'data' => array(),
                ),
            ),
        );
    }
}
