<?php
require_once dirname(__FILE__) . '/../../TestUnitDB.php';

use Tygh\Tools\SecurityHelper;

class SecurityHelperTest extends TestUnitDB
{
    /**
     * @dataProvider dpHtmlSanitizing
     */
    public function testHtmlSanitizing($original_string, $expected_output)
    {
        $this->assertEquals($expected_output, trim(SecurityHelper::sanitizeHtml($original_string)));
    }

    public function dpHtmlSanitizing()
    {
        return array(
            array(
                '<h1>Sample text</h1>',
                '<h1>Sample text</h1>',
            ),
            array(
                '<h1 onmousemove="console.log(document.cookie);">Sample text</h1>',
                '<h1>Sample text</h1>',
            ),
            array(
                '<h1>Sample text</h1> <script>window.location.href = "http://example.com/xss";</script>',
                '<h1>Sample text</h1>',
            ),
            array(
                '<a href="javascript:alert(\'XSS\');">Sample link</a>',
                '<a>Sample link</a>',
            ),
            array(
                '<img src="javascript:alert(\'XSS\');" width="30" height="80" />',
                '',
            ),
            array(
                '<img src="http://example.com/normal_image.jpg" width="30" height="80" alt="example" />',
                '<img src="http://example.com/normal_image.jpg" width="30" height="80" alt="example" />',
            ),
            array(
                '<style>li {list-style-image: url("javascript:alert(\'XSS\')"); font-size: large; }</style><ul><li>XSS</li></ul>',
                '<ul><li>XSS</li></ul>',
            ),
            array(
                '<style>li { font-size: large; }</style><ul><li>XSS</li></ul>',
                '<ul><li>XSS</li></ul>',
            ),
            array(
                '<img src="vbscript:msgbox(\'XSS\')">',
                '',
            ),
            array(
                '<a href="#" target="_blank">Link</a>',
                '<a href="#" target="_blank">Link</a>',
            ),
            array(
                '<span class="ty-rub">Text</sp',
                '<span class="ty-rub">Text</span>',
            ),
            array(
                '<span class="ty-rub">Text</span',
                '<span class="ty-rub">Text</span>',
            ),
            array(
                '<iframe width="560" height="315" src="https://www.youtube.com/embed/fvwFkLTG-Cw" frameborder="0" allowfullscreen></iframe>',
                '',
            ),
            array(
                '<object type="application/x-shockwave-flash" data="images/mouse.swf" width="400" height="300">',
                '',
            ),
            array(
                '<embed src="images/mouse.swf" width="400" height="300" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer">',
                '',
            ),
        );
    }
}